package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "deactivateUserValidator")
public class DeactivateUserValidator implements Validator {

	//private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String desc = null;
		String reason = null;

		UIInput reasonValue = (UIInput) component.getAttributes().get("reason");
		UIInput descValue = (UIInput) component.getAttributes().get("desc");

		if (reasonValue != null && reasonValue.getValue() != null) {
			reason = (String) reasonValue.getValue();
		}

		if (descValue != null && descValue.getValue() != null) {
			desc = (String) descValue.getValue();
		}

		if ((reason == null || reason.isEmpty()) && (desc == null || desc.isEmpty())) {

			String emptyDesc = "You must specify a reason for deactivating the current MHV user.<br/> <li>You must enter a description for deactivating the current MHV user.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// fail validation if certain conditions are not met
		if (reason == null || reason.isEmpty()) {

			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("deactReasonRequired"), ""));
		}

		if (desc == null || desc.isEmpty()) {

			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("deactDescRequired"), ""));

		}

	}

}
